class_name ClipableBody
extends RigidBody2D

@onready var collision_polygon_2d: CollisionPolygon2D = $CollisionPolygon2D
@onready var texture_container: Polygon2D = $TextureContainer


func clip_shape(shape: PackedVector2Array):
	var local_shape = PackedVector2Array(Array(shape).map(func(p) : return to_local(p)))
	var current_polygon = collision_polygon_2d.polygon
	var new_polygon = Geometry2D.clip_polygons(current_polygon, local_shape)
	collision_polygon_2d.polygon = new_polygon[0]
	texture_container.polygon = new_polygon[0]
